<?php

namespace Export2Swoox;

use Export2Swoox\Worker\Delete;
use Export2Swoox\Worker\Update;
use Pimcore\Log\ApplicationLogger;

class EventManager
{
    private $handledEventCount = 0;
    private $lastEvent;

    /**
     * EventManager constructor.
     *
     * @param \Zend_EventManager_EventManager $em
     */
    public function attachTo($em)
    {
        $em->attach(["object.postUpdate", "object.postAdd"], [$this, 'handleUpdate']);
        $em->attach("object.preDelete", [$this, 'handleDelete']);
    }

    /**
     * @param \Zend_EventManager_Event $event
     */
    public function handleUpdate($event)
    {
        $worker = new Update();
        $worker->updateSwoox($event, true);


        $this->handledEventCount++;
        $this->lastEvent = $event;
    }

    public function handleDelete($event)
    {
        $worker = new Delete();
        $worker->updateSwoox($event, false);

        $this->handledEventCount++;
        $this->lastEvent = $event;
    }

    /**
     * @return int
     */
    public function getHandledEventCount()
    {
        return $this->handledEventCount;
    }

    /**
     * @param int $handledEventCount
     */
    public function setHandledEventCount($handledEventCount)
    {
        $this->handledEventCount = $handledEventCount;
    }

    /**
     * @return mixed
     */
    public function getLastEvent()
    {
        return $this->lastEvent;
    }

    /**
     * @param mixed $lastEvent
     */
    public function setLastEvent($lastEvent)
    {
        $this->lastEvent = $lastEvent;
    }

}
