<?php

namespace Export2Swoox;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Pimcore\API\Plugin as PluginLib;
use Pimcore\ExtensionManager;
use Pimcore\Log\ApplicationLogger;

class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{

    public function init()
    {
        parent::init();

        AnnotationRegistry::registerLoader('class_exists');

        $em = new EventManager();
        $em->attachTo(\Pimcore::getEventManager());
    }

    public static function install()
    {
        ApplicationLogger::getInstance("Export2Swoox", true)->debug("install");
        return true;
    }

    public static function uninstall()
    {
        ApplicationLogger::getInstance("Export2Swoox", true)->debug("uninstall");
        return true;
    }

    public static function isInstalled()
    {
        //ApplicationLogger::getInstance("Export2Swoox", true)->debug("isInstalled");
        return true;
    }

    public static function getPluginConfig(){
        return (new \Zend_Config_Xml(PIMCORE_WEBSITE_PATH . ExtensionManager::getPluginConfig('Export2Swoox')['plugin']['pluginXmlEditorFile']))->toArray();
    }
}
