<?php

namespace Export2Swoox\Worker;

use Export2Swoox\Mapper\MapperInterface;
use Export2Swoox\Plugin;
use Export2Swoox\Webservice\Request;
use Pimcore\Log\ApplicationLogger;

abstract class AbstractWorker
{
    /**
     * @param \Zend_EventManager_Event $event
     */
    function updateSwoox($event, $index = true)
    {
        $config = Plugin::getPluginConfig();


        $object = $event->getTarget();

        if('object' !== $object->getType()){
            return null;
        }

        /**
         * @var $mapper MapperInterface
         */
        $mapper = null;
        $className = 'Export2Swoox\\Mapper\\' . $config['export2swoox']['namespace'] . '\\' . $object->getClassName() . 'Mapper';
        $fileToInclude = __DIR__ . '/../Mapper/' . $config['export2swoox']['namespace'] . '/' . $object->getClassName() . 'Mapper' . '.php';
        //Hätte gern nur class_exist einfach verwendet. Funktioniert auch aber intern wirft er im Nachgang der Pluginverarbeitung ein Fehler sofern die Klasse doch nicht existierte.
        if (file_exists($fileToInclude) && class_exists($className)) {
            //Klasse gibt es ...also darf auch etwas passieren
            //Neues Mapper Object erzeugen
            $mapper = new $className; //Nicht schön, aber...
            $eventWhitelist = $mapper->getEventWhitelist();
            if (in_array($event->getName(), $eventWhitelist)) {
                ApplicationLogger::getInstance("Export2Swoox", true)->debug("handle {$object->getClassName()} - index: {$index} - id: {$event->getTarget()->getId()}");
                $mapper->generateOutput($object, $index, $event);
            }
        }

        if ($mapper && sizeof($mapper->getPayload()) > 0) {
            //ab damit nach Swoox
            (new Request())->prepareAndSend($mapper, $index);
        }
    }

}
