<?php

use ExportTranslations\Api\Manager as ApiManager;

class ExportTranslations_IndexController extends \Pimcore\Controller\Action\Admin
{
    /**
     * @var ApiManager
     */
    private $apiM;

    /**
     * @throws \Zend_Exception
     */
    public function init()
    {
        $this->apiM = Zend_Registry::get('plugins.exporttranslations.apimanager');
        return parent::init();
    }

    /**
     * Reachable via http://your.domain/plugin/ExportTranslations/index/export
     */
    public function exportAction()
    {
        list($translationsUpdateCount, $translationsDeleteCount) = $this->apiM->worker()->export()->run();
        $this->getHelper('ViewRenderer')->setNoRender();
        $this->getResponse()->setHeader('Content-Type', 'application/json; charset=UTF-8');

        echo json_encode(array('message' => sprintf('Updated %d translations. Deleted %d translations.', $translationsUpdateCount, $translationsDeleteCount)));
    }

}
