<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations\Api;

use ExportTranslations\Client\Manager as ClientManager;
use ExportTranslations\Config\PluginConfig;
use ExportTranslations\EventListener\Manager as EventListenerManager;
use ExportTranslations\Model\Manager as ModelManager;
use ExportTranslations\Pimcore\Manager as PimcoreManager;
use ExportTranslations\Webservice\Manager as WebserviceManager;
use ExportTranslations\Worker\Manager as WorkerManager;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Zend_Log as Logger;
use Zend_Log_Writer_Stream as LogWriter;
use Zend_Log_Filter_Priority as LogFilter;
// For the next release of PimCore
//use Pimcore\Log\Log as Logger;
//use Pimcore\Log\Writer\Stream as LogWriter;

/**
 * Api-Manager
 *
 * @package ExportTranslations\Api
 * @author Oliver Friedrich <of@life-style.de>
 */
class Manager
{

    /**
     *
     * @var array
     */
    private $factory = array();

    /**
     * @return EventListenerManager
     */
    public function eventListener()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new EventListenerManager($this));
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return ClientManager
     */
    public function clients()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ClientManager($this));
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }

    /**
     * @return ModelManager
     */
    public function model()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelManager($this));
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WebserviceManager($this));
    }

    /**
     * @return Logger
     */
    public function logger()
    {
        if (!isset($this->factory[__FUNCTION__])) {
            $logWriter = new LogWriter(PIMCORE_LOG_DIRECTORY . '/translation-export.log');
            $logWriter->addFilter(new LogFilter((int) max(\Logger::getPriorities())));
            $this->factory[__FUNCTION__] = new Logger($logWriter);
        }
        return $this->factory[__FUNCTION__];

        // The next release of PimCore will make it easier!
//        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Logger(new LogWriter(PIMCORE_LOG_DIRECTORY . '/object-export.log', null, max(\Logger::getPriorities()))));
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = $this->serializer()->deserialize(file_get_contents(__DIR__ . '/../../../config.xml'), 'ExportTranslations\Config\PluginConfig', 'xml'));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }
}
