<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations\EventListener;

use ExportTranslations\Api\Manager as ApiManager;
use Pimcore\Model\Object\AttributUebersetzung;

/**
 * EventListener - Delete Translation
 *
 * @package ExportTranslations\EventListener
 * @author Oliver Friedrich <of@life-style.de>
 */
class Delete implements ListenerInterface
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Attach event listener
     */
    public function init()
    {
        \Pimcore::getEventManager()->attach("object.postUpdate", array($this, 'unpublish'));
        \Pimcore::getEventManager()->attach("object.postDelete", array($this, 'delete'));
    }

    /**
     * Delete translation after unpublish
     *
     * @param \Zend_EventManager_Event $event
     * @return \Zend_EventManager_Event
     */
    public function unpublish(\Zend_EventManager_Event $event)
    {
        if ($this->hasSubscribed($event) && !$event->getTarget()->isPublished()) {
            $this->apiM->logger()->debug('Triggered event unpublish-translation');
            $this->apiM->worker()->delete()->run($event->getTarget());
        }
        return $event;
    }

    /**
     * Delete translation
     *
     * @param \Zend_EventManager_Event $event
     * @return \Zend_EventManager_Event
     */
    public function delete(\Zend_EventManager_Event $event)
    {
        if ($this->hasSubscribed($event)) {
            $this->apiM->logger()->debug('Triggered event delete-translation');
            $this->apiM->worker()->delete()->run($event->getTarget());
        }
        return $event;
    }

    /**
     * @param \Zend_EventManager_Event $event
     * @return bool
     */
    private function hasSubscribed(\Zend_EventManager_Event $event)
    {
        return $event->getTarget() instanceof AttributUebersetzung;
    }
}