<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations\EventListener;

use ExportTranslations\Api\Manager as ApiManager;

/**
 * Event-Listener-Manager
 *
 * @package ExportTranslations\EventListener
 * @author Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $factory;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Init event listener
     */
    public function init()
    {
        $this->delete()->init();
        $this->update()->init();
    }

    /**
     * Translations delete event listener
     *
     * @return Delete
     */
    public function delete()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Delete($this->apiM));
    }

    /**
     * Translations update event listener
     *
     * @return Update
     */
    public function update()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Update($this->apiM));
    }

}
