<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations\Model\Request\Translations\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Request-Node
 *
 * @package ExportTranslations\Model\Request\Translations\Delete
 * @author Oliver Friedrich <of@life-style.de>
 * 
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @param string $name
     * @return Item
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

}