<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations;

use Pimcore\API\Plugin as PluginLib;
use ExportTranslations\Api\Manager as ApiManager;
use Doctrine\Common\Annotations\AnnotationRegistry;

/**
 * Plugin Install
 *
 * @package ExportTranslations\
 * @author Oliver Friedrich <of@life-style.de>
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{
    /**
     * Init plugin
     */
    public function init()
    {
        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');

        $apiM = new ApiManager();
        $apiM->eventListener()->init();

        // Register api manager
        \Zend_Registry::set('plugins.exporttranslations.apimanager', $apiM);
    }

    /**
     * @return bool
     */
    public static function needsReloadAfterInstall()
    {
        return true;
    }

    /**
     * @return string
     */
    public static function install()
    {
        $path = self::getInstallPath();

        if (!is_dir($path)) {
            mkdir($path);
        }

        if (self::isInstalled()) {
            return "ExportTranslations Plugin successfully installed.";
        } else {
            return "ExportTranslations Plugin could not be installed.";
        }
    }

    /**
     * @return string
     */
    public static function uninstall()
    {
        rmdir(self::getInstallPath());

        if (!self::isInstalled()) {
            return "ExportTranslations Plugin successfully uninstalled.";
        } else {
            return "ExportTranslations Plugin could not be uninstalled.";
        }
    }

    /**
     * @return bool
     */
    public static function isInstalled()
    {
        return is_dir(self::getInstallPath());
    }

    /**
     * @param string $language
     * @return null|string
     */
    public static function getTranslationFile($language)
    {
        return null;
    }

    /**
     * @return string
     */
    public static function getInstallPath()
    {
        return PIMCORE_PLUGINS_PATH . "/ExportTranslations/install";
    }

}