<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportTranslations\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Unit Tests
 *
 * @package ExportTranslations\Tests
 * @author Oliver Friedrich <of@life-style.de>
 */
class ManagerTest extends TestBase
{

    /**
     * Test instances
     */
    public function testApiManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('ExportTranslations\Client\Manager', $this->apiM()->clients());
        $this->assertInstanceOf('ExportTranslations\Config\PluginConfig', $this->apiM()->pluginConfig());
        $this->assertInstanceOf('ExportTranslations\EventListener\Manager', $this->apiM()->eventListener());
        $this->assertInstanceOf('ExportTranslations\Model\Manager', $this->apiM()->model());
        $this->assertInstanceOf('ExportTranslations\Pimcore\Manager', $this->apiM()->pimcore());
        $this->assertInstanceOf('ExportTranslations\Webservice\Manager', $this->apiM()->webservice());
        $this->assertInstanceOf('ExportTranslations\Worker\Manager', $this->apiM()->worker());
        $this->assertInstanceOf('Zend_Log', $this->apiM()->logger());
        $this->assertInstanceOf('JMS\Serializer\Serializer', $this->apiM()->serializer());
    }

    /**
     * @expectedException \ExportTranslations\Config\InvalidConfigException
     */
    public function testClientManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $this->apiM()->clients()->configured());
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $this->apiM()->clients()->active());
        if ($this->apiM()->clients()->active()->count()) {
            $client = $this->apiM()->clients()->active()->first();
            $this->assertInstanceOf('ExportTranslations\Config\Client', $client);
        }
        if ($this->apiM()->clients()->configured()->count()) {
            $client = $this->apiM()->clients()->configured()->first();
            $this->assertInstanceOf('ExportTranslations\Config\Client', $client);
            $service = $this->apiM()->clients()->service($client, 'Translation::Update');
            $this->assertInstanceOf('ExportTranslations\Config\Service', $service);
            $this->apiM()->clients()->service($client, 'UnknownController::UnknownAction');
        }
    }

    public function testModelManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('ExportTranslations\Model\Request\Translations\Delete\Factory', $this->apiM()->model()->translationsDelete());
        $this->assertInstanceOf('ExportTranslations\Model\Request\Translations\Update\Factory', $this->apiM()->model()->translationsUpdate());
    }

    public function testPimcoreManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('ExportTranslations\Pimcore\Config', $this->apiM()->pimcore()->config());
    }

    public function testWebserviceManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('ExportTranslations\Webservice\Request', $this->apiM()->webservice()->request());
        $this->assertInstanceOf('ExportTranslations\Webservice\Response', $this->apiM()->webservice()->response());
    }

    public function testWorkerManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('ExportTranslations\Worker\Delete', $this->apiM()->worker()->delete());
        $this->assertInstanceOf('ExportTranslations\Worker\Update', $this->apiM()->worker()->update());
    }
}
