pimcore.registerNS("pimcore.plugin.exporttranslations");
pimcore.plugin.exporttranslations = Class.create(pimcore.plugin.admin, {
    getClassName: function () {
        return "pimcore.plugin.exporttranslations";
    },
    initialize: function () {
        pimcore.plugin.broker.registerPlugin(this);
        this.navEl = Ext.get('pimcore_menu_logout').insertSibling('<li id="pimcore_menu_custom" class="pimcore_menu_item icon-beaker">Heimdall</li>');
    },
    pimcoreReady: function (params, broker) {
        var menu = new Ext.menu.Menu({
            items: [{
                text: "Export translations",
                iconCls: "pimcore_icon_export_translations",
                handler: function () {
                    Ext.MessageBox.confirm('Confirm', 'Start full export of translations?', function(btn) {
                        if ("yes" === btn) {
                            Ext.Ajax.request({
                                url: '/plugin/ExportTranslations/index/export',
                                method: 'POST',
                                headers: { 'Content-Type': 'application/json' },
                                success: function(conn, response, options, eOpts) {
                                    var response = Ext.decode(conn.responseText);
                                    Ext.MessageBox.alert('Success!', 'Translations full export done. ' + response.message);
                                },
                                failure: function(conn, response, options, eOpts) {
                                    Ext.MessageBox.alert('Error!', 'Translations full export failed.');
                                }
                            });
                        }
                    });
                }
            }],
            cls: "pimcore_navigation_flyout"
        });
        var toolbar = pimcore.globalmanager.get("layout_toolbar");
        this.navEl.on("mousedown", toolbar.showSubMenu.bind(menu));
    }
});
var exporttranslationsPlugin = new pimcore.plugin.exporttranslations();