<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Client;

use Publikat\Pimcore\ExportTranslationsBundle\Api\Manager as ApiManager;
use Publikat\Pimcore\ExportTranslationsBundle\Config\Client;
use Publikat\Pimcore\ExportTranslationsBundle\Config\InvalidConfigException;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Client Manager
 *
 * @package Publikat\Pimcore\ExportTranslationsBundle\Client
 * @author Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Get list of configured clients
     *
     * @return Client[]
     */
    public function configured()
    {
        return $this->apiM->pluginConfig()->getClients();
    }

    /**
     * Get list of active clients
     *
     * @param string $clientId Set client-id, if list should be filtered to one client
     * @return Client[]
     */
    public function active($clientId = null)
    {
        $clients = new ArrayCollection();
        foreach ($this->apiM->pluginConfig()->getClients() as $client) {
            if ($client->isActive() && (null == $clientId || $client->getId() == $clientId)) {
                $clients->add($client);
            }
        }
        return $clients;
    }

    /**
     * Get service from service list depending on service name
     *
     * @param Client $client
     * @param string $serviceName
     * @return Service
     * @throws InvalidConfigException
     */
    public function service(Client $client, $serviceName)
    {
        foreach ($client->getServices() as $service) {
            if ($serviceName == $service->getName()) {
                return $service;
            }
        }
        throw new InvalidConfigException(sprintf('Cannot find service configuration for %s', $serviceName));
    }
}