<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Model\Response\Errors;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("response")
 * @Serializer\ExclusionPolicy("all")
 *
 */
class Errors
{

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     */
    private $status;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     */
    private $message;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("count")
     * @Serializer\Type("integer")
     */
    private $count;

    /**
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Publikat\Pimcore\ExportTranslationsBundle\Model\Response\Errors\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * Define Var Type
     * @var ArrayCollection
     */
    private $errors;

    /**
     *
     * @var array
     */
    private $statusMessages;

    public function __construct()
    {
        $this->errors = new ArrayCollection();
        $this->count = 0;
        $this->statusMessages = [200 => 'OK', 400 => 'Bad Request', 401 => 'Forbidden', 500 => 'Internal Server Error'];
    }

    /**
     *
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = (int) $status;
        if(isset($this->statusMessages[$status])){
            $this->message = $this->statusMessages[$status];
        } else {
            $this->message = 'Not Found';
        }
    }

    /**
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * count + 1
     */
    public function addCount()
    {
        $this->count++;
    }

    /**
     * count - 1
     */
    public function removeCount()
    {
        $this->count--;
    }

    /**
     *
     * @param Error $error
     * @return Errors
     */
    public function addError(Error $error)
    {
        $this->errors[] = $error;
        $this->addCount();
        return $this;
    }

    /**
     *
     * @param Error $error
     */
    public function removeError(Error $error)
    {
        $this->errors->removeElement($error);
        $this->removeCount();
    }

    /**
     * Get Errors
     *
     * @return Error[]
     */
    public function getError()
    {
        return $this->errors;
    }

    /**
     *
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < $this->count;
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->count;
    }

    /**
     *
     * @return string
     */
    public function getMessage(){
        return $this->message;
    }

}
