<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportTranslations\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Unit Tests
 *
 * @package ExportTranslations\Tests
 * @author Oliver Friedrich <of@life-style.de>
 */
class ClientTest extends TestBase
{

    /**
     * Test config structure
     *
     * @expectedException \ExportTranslations\Config\InvalidConfigException
     */
    public function testClientConfig()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        if ($this->apiM()->clients()->active()->count()) {
            $client = $this->apiM()->clients()->active()->first();
            $this->assertInstanceOf('ExportTranslations\Config\Client', $client);
        }
        if ($this->apiM()->clients()->configured()->count()) {
            $client = $this->apiM()->clients()->configured()->first();
            $this->assertInstanceOf('ExportTranslations\Config\Client', $client);
            $service = $this->apiM()->clients()->service($client, 'Translation::Update');
            $this->assertInstanceOf('ExportTranslations\Config\Service', $service);
            $service = $this->apiM()->clients()->service($client, 'Translation::Delete');
            $this->assertInstanceOf('ExportTranslations\Config\Service', $service);
            $this->apiM()->clients()->service($client, 'UnknownController::UnknownAction');
        }
    }

}
