<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Model;

use Publikat\Pimcore\ExportTranslationsBundle\Api\Manager as ApiManager;
use Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Delete\Factory as TranslationsDeleteFactory;
use Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Update\Factory as TranslationsUpdateFactory;

/**
 * Model Manager
 *
 * @package Publikat\Pimcore\ExportTranslationsBundle\Model
 * @author Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $factory;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return TranslationsUpdateFactory
     */
    public function translationsUpdate()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslationsUpdateFactory($this->apiM));
    }

    /**
     * @return TranslationsDeleteFactory
     */
    public function translationsDelete()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslationsDeleteFactory($this->apiM));
    }
}