<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Worker;

use Publikat\Pimcore\ExportTranslationsBundle\Api\Manager as ApiManager;
use Pimcore\Model\Object\AttributUebersetzung;
use Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Delete\Request;

/**
 * Delete Worker
 *
 * @package Publikat\Pimcore\ExportTranslationsBundle\Worker
 * @author Oliver Friedrich <of@life-style.de>
 */
class Delete
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param AttributUebersetzung $object
     *
     * @throws \Publikat\Pimcore\ExportTranslationsBundle\Config\InvalidConfigException
     */
    public function run(AttributUebersetzung $object)
    {
        // Prepare request
        $modelRequest = $this->apiM->model()->translationsDelete()->request();

        // Prepare data
        $this->delete($modelRequest, $object);

        $this->apiM->logger()->debug(sprintf('Translation "%s" (ID %d) added to delete request',
            $object->getKey(),
            $object->getId()));

        // Send request
        foreach ($this->apiM->clients()->active() as $client) {
            $service = $this->apiM->clients()->service($client, 'Translation::Delete');
            $this->apiM->webservice()->request()->send($modelRequest, $client, $service);
        }
    }

    /**
     * @param Request $request
     * @param AttributUebersetzung $object
     */
    private function delete(Request $request, AttributUebersetzung $object)
    {
        $item = $this->apiM->model()->translationsDelete()->item($request);
        $item->setName($object->getKey());
    }
}