<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Worker;

use Publikat\Pimcore\ExportTranslationsBundle\Api\Manager as ApiManager;
use Pimcore\Model\Object\AttributUebersetzung;
use Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Update\Request;

/**
 * Update-Worker
 *
 * @package Publikat\Pimcore\ExportTranslationsBundle\Worker
 * @author Oliver Friedrich <of@life-style.de>
 */
class Update
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param AttributUebersetzung $object
     *
     * @throws \Publikat\Pimcore\ExportTranslationsBundle\Config\InvalidConfigException
     */
    public function run(AttributUebersetzung $object)
    {
        // Object not published
        if (!$object->isPublished()) {
            $this->apiM->logger()->debug(sprintf('Translation "%s" (ID %d) not exported: not published', $object->getKey(), $object->getId()));
            return;
        }

        // Prepare request
        $modelRequest = $this->apiM->model()->translationsUpdate()->request();

        // Prepare data
        $this->update($modelRequest, $object);

        $this->apiM->logger()->debug(sprintf('Translation "%s" (ID %d) added to update request',
            $object->getKey(),
            $object->getId()));

        // Send request
        foreach ($this->apiM->clients()->active() as $client) {
            $service = $this->apiM->clients()->service($client, 'Translation::Update');
            $this->apiM->webservice()->request()->send($modelRequest, $client, $service);
        }
    }

    /**
     * @param Request $request
     * @param AttributUebersetzung $object
     */
    private function update(Request $request, AttributUebersetzung $object)
    {
        $item = $this->apiM->model()->translationsUpdate()->item($request);
        $item->setName($object->getKey());

        // Cycle through configured languages
        foreach ($this->apiM->pimcore()->config()->getLanguages() as $language) {

            // Skip empty values
            $value = $object->getAttributUebersetzungText($language);
            if (null === $value) {
                continue;
            }

            // Add translation
            $this->apiM->model()->translationsUpdate()->valueItem($item)
                ->setLanguage($language)
                ->setValue($value);
        }
    }
}
