<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Api;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use MuleMessageBufferBundle\Service\MuleMessageBufferDispatcher;
use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\ExportTranslationsBundle\Client\Manager as ClientManager;
use Publikat\Pimcore\ExportTranslationsBundle\Config\PluginConfig;
use Publikat\Pimcore\ExportTranslationsBundle\Model\Manager as ModelManager;
use Publikat\Pimcore\ExportTranslationsBundle\Pimcore\Manager as PimcoreManager;
use Publikat\Pimcore\ExportTranslationsBundle\Webservice\Manager as WebserviceManager;
use Publikat\Pimcore\ExportTranslationsBundle\Worker\Manager as WorkerManager;

/**
 * Api-Manager
 *
 * @package Publikat\Pimcore\ExportTranslationsBundle\Api
 * @author Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     *
     * @var array
     */
    private $factory = [];

    /**
     * @var null|MuleMessageBufferDispatcher
     */
    private $muleDispatcher;

    /**
     * Manager constructor.
     *
     * @param null|MuleMessageBufferDispatcher $muleDispatcher
     */
    public function __construct(?MuleMessageBufferDispatcher $muleDispatcher)
    {
        $this->muleDispatcher = $muleDispatcher;
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return ClientManager
     */
    public function clients()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ClientManager($this));
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }

    /**
     * @return ModelManager
     */
    public function model()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelManager($this));
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WebserviceManager($this));
    }

    /**
     * @return ApplicationLogger
     */
    public function logger()
    {
        return ApplicationLogger::getInstance("ExportTranslations", true);;
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = $this->serializer()->deserialize(file_get_contents(__DIR__ . '/../Resources/config/config.' . \Pimcore\Config::getEnvironment() . '.xml'), 'Publikat\Pimcore\ExportTranslationsBundle\Config\PluginConfig', 'xml'));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }

    /**
     * @return null|MuleMessageBufferDispatcher
     */
    public function muleDispatcher()
    {
        return $this->muleDispatcher;
    }
}
