<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\EventListener;

use Pimcore\Event\Model\ElementEventInterface;
use Pimcore\Model\Object\AttributUebersetzung;
use Publikat\Pimcore\ExportTranslationsBundle\Api\Manager as ApiManager;

/**
 * Class DataObjectListener
 *
 * @author  Jochen Califice <jc@life-style.de>
 * @package Publikat\Pimcore\ExportTranslationsBundle\EventListener
 */
class DataObjectListener
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param ElementEventInterface $event
     *
     * @throws \Exception
     */
    public function onPostUpdate(ElementEventInterface $event) {
        if ($event->getObject() instanceof AttributUebersetzung) {
            $this->apiM->logger()->debug('Triggered event update-translation');
            $this->apiM->worker()->update()->run($event->getObject());

            if (!$event->getObject()->isPublished()) {
                $this->apiM->logger()->debug('Triggered event unpublish-translation');
                $this->onPostDelete($event);
            }
        }
    }

    /**
     * @param ElementEventInterface $event
     *
     * @throws \Exception
     */
    public function onPostDelete(ElementEventInterface $event)
    {
        if ($event->getObject() instanceof AttributUebersetzung) {
            $this->apiM->logger()->debug('Triggered event delete-translation');
            $this->apiM->worker()->delete()->run($event->getObject());
        }
    }
}