<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Update;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Request-Node
 *
 * @package Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Update
 * @author Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("ValueItems")
     * @Serializer\Type("ArrayCollection<Publikat\Pimcore\ExportTranslationsBundle\Model\Request\Translations\Update\ValueItem>")
     * @Serializer\XmlList(entry="ValueItem")
     *
     * @var ArrayCollection
     */
    private $valueItems;

    /**
     * Item constructor.
     */
    public function __construct()
    {
        $this->valueItems = new ArrayCollection();
    }

    /**
     * @param string $name
     * @return Item
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @param ValueItem $valueItem
     * @return Item
     */
    public function addValueItem(ValueItem $valueItem)
    {
        $this->valueItems->add($valueItem);
        return $this;
    }

    /**
     * Delete empty value array
     *
     * @Serializer\PreSerialize
     */
    public function nullValueItems()
    {
        if (null !== $this->valueItems && !$this->valueItems->count()) {
            $this->valueItems = null;
        }
    }

}