<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportTranslations\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

class EventListenerTest extends TestBase
{

    public function testDelete()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->delete()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postDelete', $this->getAttributUebersetzungUnpublished());
        $apiM->eventListener()->delete()->delete($event);
    }

    public function testNotSubscibed()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->apiM()->eventListener()->update()->update(new \Zend_EventManager_Event('object.postUpdate'));
        $this->apiM()->eventListener()->delete()->unpublish(new \Zend_EventManager_Event('object.postUpdate'));
        $this->apiM()->eventListener()->delete()->delete(new \Zend_EventManager_Event('object.postDelete'));
    }

    public function testUnpublish()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->delete()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postUpdate', $this->getAttributUebersetzungUnpublished());
        $apiM->eventListener()->delete()->unpublish($event);
    }

    public function testUpdate()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->update()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postUpdate', $this->getAttributUebersetzungUnpublished());
        $apiM->eventListener()->update()->update($event);
    }
}
