<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportTranslations\Tests;

use ExportTranslations\Plugin;

/**
 * Test plugin.php
 *
 * @package ExportTranslations
 */
class PluginTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \ExportTranslations\Plugin
     */
    private $plugin;

    public function testInit()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $plugin = new Plugin();
        $plugin->init();
        $isInstalled = Plugin::isInstalled();

        $this->assertTrue(\Zend_Registry::isRegistered('plugins.exporttranslations.apimanager'));
        $this->assertInstanceOf('ExportTranslations\Api\Manager', \Zend_Registry::get('plugins.exporttranslations.apimanager'));
        $this->assertTrue(Plugin::needsReloadAfterInstall());
        $this->assertTrue(is_string(Plugin::uninstall()));
        $this->assertFalse(Plugin::isInstalled());
        $this->assertTrue(is_string(Plugin::install()));
        $this->assertTrue(Plugin::isInstalled());
        $this->assertTrue(is_string(Plugin::getInstallPath()));
        $this->assertTrue(file_exists(Plugin::getInstallPath()));
        $this->assertNull(Plugin::getTranslationFile('en'));

        if (!$isInstalled) {
            Plugin::uninstall();
        }
    }

}
