<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations\Model\Request\Translations\Update;

use ExportTranslations\Api\Manager as ApiManager;

/**
 * Translations Update Factory
 *
 * @package ExportTranslations\Model\Request\Translations\Update
 * @author Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Create new request
     *
     * @return Request
     */
    public function request()
    {
        return new Request();
    }

    /**
     * Create new item
     *
     * @param Request $request
     * @return Item
     */
    public function item(Request $request)
    {
        $item = new Item();
        $request->addItem($item);
        return $item;
    }

    /**
     * Create new translation value item
     *
     * @param Item $item
     * @return ValueItem
     */
    public function valueItem(Item $item)
    {
        $valueItem = new ValueItem();
        $item->addValueItem($valueItem);
        return $valueItem;
    }

}