<?php

/**
 * PimCore Export Translations Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportTranslations\Model\Request\Translations\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Request-Node
 *
 * @package ExportTranslations\Model\Request\Translations\Update
 * @author Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Value")
 */
class ValueItem
{

    /**
     * @Serializer\SerializedName("Language")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $language;

    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $value;

    /**
     * Set Language
     *
     * @param string $language
     * @return ValueItem
     */
    public function setLanguage($language)
    {
        $this->language = (string)$language;
        return $this;
    }

    /**
     * Set Value
     *
     * @param string $value
     * @return ValueItem
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

}