<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportTranslations\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Unit Tests
 *
 * @package ExportTranslations\Tests
 * @author Oliver Friedrich <of@life-style.de>
 */
class WorkerTest extends TestBase
{

    /**
     * @expectedException \ExportTranslations\Webservice\InvalidResponseException
     */
    public function testDelete()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $apiM = $this->webserviceBuildApiM();
        $object = $this->getAttributUebersetzungPublished();
        if ($object) {
            // Success 200
            $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
            $apiM->worker()->delete()->run($object);

            // Error 400
            $this->webserviceAddResponse(400, array('Content-Type' => 'application/json'), $this->webserviceCreateError($apiM));
            $apiM->worker()->delete()->run($object);
        }
    }

    public function testExport()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $apiM = $this->webserviceBuildApiM();

        // Success 200
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $apiM->worker()->export()->run();
    }

    /**
     * @expectedException \ExportTranslations\Webservice\InvalidResponseException
     */
    public function testUpdate()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $apiM = $this->webserviceBuildApiM();
        $object = $this->getAttributUebersetzungPublished();
        if ($object) {
            // Success 200
            $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
            $apiM->worker()->update()->run($object);

            // Error 400
            $this->webserviceAddResponse(400, array('Content-Type' => 'application/json'), $this->webserviceCreateError($apiM));
            $apiM->worker()->update()->run($object);
        }
    }

}
