<?php

/**
 * PimCore Article Import Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ImportArticle;

use Pimcore\API\Plugin as PluginLib;
use ImportArticle\Api\Manager as ApiManager;
use Doctrine\Common\Annotations\AnnotationRegistry;

/***
 * Class Plugin
 * @package ImportArticle
 * @codeCoverageIgnore
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{

    public function init()
    {
        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');

        $apiM = new ApiManager();

        // Register api manager
        \Zend_Registry::set('plugins.importarticle.apimanager', $apiM);
    }

    /***
     * @return string
     */
    public static function install()
    {
        $path = self::getInstallPath();

        if (!is_dir($path)) {
            mkdir($path);
        }

        if (self::isInstalled()) {
            return "ImportArticle Plugin successfully installed.";
        } else {
            return "ImportArticle Plugin could not be installed.";
        }
    }

    /***
     * @return string
     */
    public static function uninstall()
    {
        rmdir(self::getInstallPath());

        if (!self::isInstalled()) {
            return "ExportTranslations Plugin successfully uninstalled.";
        } else {
            return "ExportTranslations Plugin could not be uninstalled.";
        }
    }

    /***
     * @return mixed
     */
    public static function isInstalled()
    {
        //return is_dir(self::getInstallPath());
        return true;
    }
}
