<?php

/**
 * PimCore Article Import Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Publikat\Pimcore\ImportArticleBundle\Api;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\ImportArticleBundle\Worker\Manager as WorkerManager;

/***
 * Class Manager
 * @package Publikat\Pimcore\ImportArticleBundle\Api
 */
class Manager
{
    /**
     * @var array
     */
    private $factory = array();

    /**
     * @return ApplicationLogger
     */
    public function logger()
    {
        return ApplicationLogger::getInstance('ImportArticle', true);
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }
}
