<?php

/**
 * PimCore Article Import Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

use ImportArticle\Api\Manager as ApiManager;

/***
 * Class ImportArticle_IndexController
 */
class ImportArticle_IndexController extends \Pimcore\Controller\Action
{
    /**
     * @var ApiManager
     */
    private $apiM;

    /**
     * @throws \Zend_Exception
     */
    public function init()
    {

        \Pimcore\Model\Version::disable();

        $this->apiM = Zend_Registry::get('plugins.importarticle.apimanager');
        parent::init();
    }

    /***
     * @param $json
     * @return string
     */
    private function responseSuccess($json)
    {
        $this->getResponse()->setHeader('Content-Type', 'application/json');

        return $json;
    }

    /***
     * @param string $message
     *
     * @return string
     */
    private function responseError($message = '')
    {

        $this->getResponse()->setHeader('Content-Type', 'application/json');
        if ($message != '') {
            return json_encode(array('message' => 'error: ' . $message));
        } else {
            return json_encode(array('message' => 'error'));
        }
    }

    /***
     * Reachable via http://your.domain/plugin/ImportArticle/index/import
     *
     * @return mixed
     * @throws \Exception
     */
    public function importAction()
    {

        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '1024M');
        ini_set('display_errors', 0);
        error_reporting(E_ALL & ~E_NOTICE);

        try {
            $this->disableViewAutoRender();
            $this->disableLayout();

            $requestBody = file_get_contents('php://input');
            // Check if body is valid XML
            $checkXML = simplexml_load_string($requestBody);
            if (!$checkXML) {
                echo $this->responseError('error: Request is no valid XML!');
                exit;
            }
            $successStatus = $this->apiM->worker()->import()->run($requestBody);
            echo $this->responseSuccess($successStatus);
        } catch (\Exception $e) {
            $this->apiM->logger()->log(sprintf('Error: %s %s!', $e->getMessage(), $e->getTraceAsString()), \Zend_Log::ERR);
            echo $this->responseError($e->getMessage());
        }
    }

}
