<?php

/**
 * PimCore Article Import Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ImportArticle\Api;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use ImportArticle\Worker\Manager as WorkerManager;
use Zend_Log as Logger;
use Zend_Log_Writer_Stream as LogWriter;
use Zend_Log_Filter_Priority as LogFilter;
// For the next release of PimCore
//use Pimcore\Log\Log as Logger;
//use Pimcore\Log\Writer\Stream as LogWriter;

/***
 * Class Manager
 * @package ImportArticle\Api
 */
class Manager
{
    /**
     * @var array
     */
    private $factory = array();

    /**
     * @return Logger
     */
    public function logger()
    {
        if (!isset($this->factory[__FUNCTION__])) {
            $logWriter = new LogWriter(PIMCORE_LOG_DIRECTORY . '/import_article.log');
            $logWriter->addFilter(new LogFilter((int) max(\Logger::getPriorities())));
            $this->factory[__FUNCTION__] = new Logger($logWriter);
        }
        return $this->factory[__FUNCTION__];

        // The next release of PimCore will make it easier!
        //return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Logger(new LogWriter(PIMCORE_LOG_DIRECTORY . '/import_article.log', null, max(\Logger::getPriorities()))));
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }
}
