<?php

namespace ImportArticle\Model\Request;

use Publikat\Model\Xml\Item\ItemTransfer;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Item
 *
 * @package Stylefile\Pimcore\RestClientBundle\Model\Request
 *
 * @Serializer\XmlRoot("Item")
 * @Serializer\ExclusionPolicy("all")
 */
class Item
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("ArrayCollection<Publikat\Model\Xml\Item\ItemTransfer>")
     * @Serializer\XmlList(entry = "ItemTransfer", inline = true)
     */
    private $elements = [];


    /**
     * @return ItemTransfer[]
     */
    public function getElements()
    {
        return $this->elements;
    }
}
