<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ImportArticleBundle\Tests;

use Publikat\Pimcore\ImportArticleBundle\Model\Manager as modelM;

require_once dirname(__FILE__) . '/TestBase.php';

/***
 * Class ManagerTest
 * @package Publikat\Pimcore\ImportArticleBundle\Tests
 */
class ManagerTest extends TestBase
{
    /**
     * Test instances
     */
    public function testApiManager()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('ImportArticle\Worker\Manager', $this->apiM()->worker());
        $this->assertInstanceOf('Zend_Log', $this->apiM()->logger());
        $this->assertInstanceOf('JMS\Serializer\Serializer', $this->apiM()->serializer());

        $model = new modelM($this->apiM());

        $this->assertInstanceOf('ImportArticle\Model\Request\Item',  $model->requestItem()->item());
    }

}
