<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ImportArticleBundle\Controller;

use Publikat\Pimcore\ImportArticleBundle\Api\Manager as ApiManager;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class IndexController
 *
 * @Route("/plugin/ImportArticle", name="import_article")
 *
 * @package Publikat\Pimcore\ImportArticleBundle\Controller
 */
class IndexController extends AbstractController
{
    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * IndexController constructor.
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        \Pimcore\Model\Version::disable();
    }

    /**
     * @Route("/index/import", name="_import")
     */
    public function import(Request $request)
    {
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '1024M');
        ini_set('display_errors', 0);
        error_reporting(E_ALL & ~E_NOTICE);

        try {
            $requestBody = $request->getContent();
            // Check if body is valid XML
            $checkXML = simplexml_load_string($requestBody);
            if (!$checkXML) {
                return new JsonResponse(['message' => 'error: Request is no valid XML!']);
            }
            $successStatus = $this->apiM->worker()->import()->run($requestBody);
            return new JsonResponse($successStatus, 200, [], true);
        } catch (\Exception $e) {
            $this->apiM->logger()->error(sprintf('Error: %s %s!', $e->getMessage(), $e->getTraceAsString()));
            return new JsonResponse(['message' => 'error: ' . $e->getMessage()]);
        }
    }
}