<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\PublikatProductImagesBundle\DependencyInjection;

use Lifestyle\Pimcore\PublikatProductImagesBundle\Client\WebdavClient;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class PublikatProductImagesExtension
 *
 * @package Lifestyle\Pimcore\PublikatProductImagesBundle\DependencyInjection
 */
class PublikatProductImagesExtension extends Extension
{
    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        if ($container->hasDefinition(WebdavClient::class)) {
            $definition = $container->getDefinition(WebdavClient::class);
            $definition->setArgument(0, [
                'baseUri' => $config['webdav_client']['base_uri'],
                'userName' => $config['webdav_client']['username'],
                'password' => $config['webdav_client']['password'],
            ]);
            $definition->setArgument(1, [
                'certFile' => $config['webdav_client']['cert_file'],
                'certType' => $config['webdav_client']['cert_type'],
                'certPassword' => $config['webdav_client']['cert_password'],
                'keyFile' => $config['webdav_client']['key_file'],
                'keyType' => $config['webdav_client']['key_type'],
                'keyPassword' => $config['webdav_client']['key_password'],
            ]);
        }
    }
}
