<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\PublikatProductImagesBundle\Client;

/**
 * Class WebdavClient
 */
class WebdavClient extends \Sabre\DAV\Client
{
    /**
     * WebdavClient constructor.
     *
     * @param array $settings
     * @param array $certificateInfo
     */
    public function __construct(array $settings, array $certificateInfo)
    {
        parent::__construct($settings);
        $this->addCurlSetting(CURLOPT_SSLCERT, $certificateInfo['certFile']);
        $this->addCurlSetting(CURLOPT_SSLCERTTYPE, $certificateInfo['certType']);
        $this->addCurlSetting(CURLOPT_SSLCERTPASSWD, $certificateInfo['certPassword']);
        $this->addCurlSetting(CURLOPT_SSLKEY, $certificateInfo['keyFile']);
        $this->addCurlSetting(CURLOPT_SSLKEYTYPE, $certificateInfo['keyType']);
        $this->addCurlSetting(CURLOPT_SSLKEYPASSWD, $certificateInfo['keyPassword']);
        $this->addCurlSetting(CURLOPT_SSL_VERIFYPEER, false);
    }
}
