<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\PublikatProductImagesBundle\EventListener;

use Lifestyle\Pimcore\PublikatProductImagesBundle\Client\WebdavClient;
use Pimcore\Event\Model\AssetEvent;
use Pimcore\Log\ApplicationLogger;

/**
 * Class AssetAssignedListener
 *
 * @package Lifestyle\Pimcore\PublikatProductImagesBundle\EventListener
 */
class AssetAssignedListener
{
    /**
     * @var WebdavClient
     */
    protected $webdavClient;

    /**
     * @var ApplicationLogger
     */
    protected $applicationLogger;

    /**
     * AssetAssignedListener constructor.
     *
     * @param WebdavClient      $webdavClient
     * @param ApplicationLogger $applicationLogger
     */
    public function __construct(WebdavClient $webdavClient, ApplicationLogger $applicationLogger)
    {
        $this->webdavClient = $webdavClient;
        $this->applicationLogger = $applicationLogger;
    }

    /**
     * @param AssetEvent $assetEvent
     */
    public function onAssetAssigned(AssetEvent $assetEvent)
    {
        // upload file
        $fileName = 'P.' . $assetEvent->getAsset()->getFileName();
        $response = $this->webdavClient->request('PUT', $fileName, $assetEvent->getAsset()->getData());
        if (intval($response['statusCode']) > 400) {
            $this->applicationLogger->error($response['body'], ['component' => 'webdav']);
        }
    }
}
