<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveChangesTracking\Tests\Api;

use SaveChangesTracking\Api\Manager;

/***
 * Class ManagerTest
 * @package SaveChangesTracking\Tests\Api
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Manager
     */
    private $testObject = null;

    public function setUp()
    {
        $this->testObject = new Manager();
    }

    public function testWorker()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('SaveChangesTracking\Worker\Manager', $this->testObject->worker());
    }

    public function testDatabase()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('Pimcore\Db\Wrapper', $this->testObject->database());
    }

    public function testFolder()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('Pimcore\Model\Object\Folder', $this->testObject->folder());
    }
}
