<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveChangesTracking\Tests\Worker;

use SaveChangesTracking\Api\Manager as ApiManager;
use SaveChangesTracking\Worker\Manager;
use SaveChangesTracking\Worker\ChangesTracking;
use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\Localizedfield;

/***
 * Class ManagerTest
 * @package SaveChangesTracking\Tests\Worker
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var ChangesTracking
     */
    private $testObject = null;

    public function setUp()
    {
        $manager = new Manager($this->createMock(true));
        $this->testObject = $manager->changesTracking();
    }

    /***
     * @param $isEmpty bool
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    public function createMock($isEmpty)
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        // Mock api manager
        $apiManagerMock = $this->getMockBuilder('\SaveChangesTracking\Api\Manager')
            ->setMethods(['database', 'folder', 'worker'])
            ->getMock();

        $apiManager = new ApiManager();
        $apiManager->worker();

        // real worker will be returned
        $apiManagerMock->method('worker')
            ->willReturn($apiManager->worker());

        $databaseDataFactoryStub = $this->getMockBuilder('\Pimcore\Db')
            ->setMethods(['query', 'fetchAll'])
            ->disableOriginalConstructor()
            ->getMock();

        $databaseDataFactoryStub->method('query')
            ->willReturn($databaseDataFactoryStub);

        // demo data
        $testArray['de']['datenblattMaterial'] = 'Toller Test!';
        $testArray['de']['datenblattSohle'] = 'Geilomat!';
        $testArray['fr']['datenblattMaterial'] = 'Tóllér Tést!';
        $testArray['fr']['datenblattSohle'] = 'Géilómat!';
        $returnValue = $testArray;
        if($isEmpty){
            $returnValue = [];
        }

        $databaseDataFactoryStub
            ->expects($this->any())
            ->method('fetchAll')
            ->willReturn($returnValue);

        $apiManagerMock->method('database')
            ->willReturn($databaseDataFactoryStub);

        return $apiManagerMock;
    }

    public function testGetOldData()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        // empty result
        $family = new ArtikelFamilie();
        $localizedField = new Localizedfield();

        // process every original language
        $testArray['de'] = ['datenblattPenunsier' => 'Toller Test!'];
        $testArray['de'] = ['datenblattBla' => 'Geilomat!'];

        $localizedField->setItems($testArray);
        $family->setLocalizedfields($localizedField);

        $returnData = $this->testObject->getOldData($family);
        $this->assertNull($returnData);

        // filled result
        $manager = new Manager($this->createMock(false));
        $this->testObject = $manager->changesTracking();
        $returnData = $this->testObject->getOldData($family);
        $this->assertTrue(is_array($returnData));
        $this->assertTrue(count($returnData) == 2);
    }
}
