<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\SaveChangesTrackingBundle\Api;

use Pimcore\Db;
use Pimcore\Db\ConnectionInterface;
use Pimcore\Model\Object\Folder;
use Publikat\Pimcore\SaveChangesTrackingBundle\Worker\Manager as WorkerManager;

/**
 * Class Manager
 * @package Publikat\Pimcore\SaveChangesTrackingBundle\Api
 */
class Manager
{
    /**
     * @var []
     */
    private $factory = [];

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] =
            new WorkerManager($this));
    }

    /**
     * @return Folder
     */
    public function folder()
    {
        return new Folder();
    }

    /***
     * @return mixed|ConnectionInterface
     */
    public function database()
    {
        return Db::get();
    }
}
