<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\SaveChangesTrackingBundle\EventListener;

use Pimcore\Event\Model\ElementEventInterface;
use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\SaveChangesTrackingBundle\Api\Manager as ApiManager;

/**
 * Class DataObjectListener
 *
 * @package Publikat\Pimcore\SaveChangesTrackingBundle\EventListener
 */
class DataObjectListener
{
    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * DataObjectListener constructor.
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param ElementEventInterface $event
     */
    public function onPreUpdate(ElementEventInterface $event)
    {
        try{
            $object = $event->getElement();
            $this->apiM->worker()->changesTracking()->run($object);
        } catch(\Exception $exception){
            ApplicationLogger::getInstance('SaveChangesTracking', true)->error( $exception->getMessage());
        }
    }
}
