<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveChangesTracking\Api;

use Pimcore\Model\Object\Folder;
use Pimcore\Db;
use SaveChangesTracking\Worker\Manager as WorkerManager;

/***
 * Class Manager
 * @package SaveChangesTracking\Api
 */
class Manager
{
    /**
     * @var []
     */
    private $factory = [];

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] =
            new WorkerManager($this));
    }

    /**
     * @return Folder
     */
    public function folder()
    {
        return new Folder();
    }

    /***
     * @return mixed|\Zend_Db_Adapter_Abstract
     */
    public function database()
    {
        return Db::get();
    }
}
