<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveChangesTracking;

use Pimcore\API\Plugin as PluginLib;
use SaveChangesTracking\Api\Manager as ApiManager;

/***
 * Class Plugin
 * @package SaveChangesTracking
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{
    public function init()
    {
        parent::init();

        \Pimcore::getEventManager()->attach("object.preUpdate", [$this, "handleObjectPreSaveEvent"]);
    }

    /**
     * handleObjectPreSaveEvent
     *
     * @param \Zend_EventManager_Event $event
     */
    public function handleObjectPreSaveEvent(\Zend_EventManager_Event $event)
    {
        try{
            $object = $event->getTarget();
            $apiM = new ApiManager();
            $apiM->worker()->changesTracking()->run($object);
        }catch(\Exception $exception){
            \Pimcore\Log\Simple::log('SaveChangesTracking', $exception->getMessage());
        }

    }

    public function handleDocument($event)
    {

    }

    public static function install()
    {
        // implement your own logic here
        return true;
    }

    public static function uninstall()
    {
        // implement your own logic here
        return true;
    }

    public static function isInstalled()
    {
        // implement your own logic here
        return true;
    }
}
