<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveChangesTracking\Tests;

use SaveChangesTracking\Plugin;

/**
 * Test plugin.php
 *
 * @package SaveChangesTracking
 */
class PluginTest extends \PHPUnit_Framework_TestCase
{
    public function testInit()
    {
        $plugin = new Plugin();
        $plugin->init();
        $isInstalled = Plugin::isInstalled();

        $this->assertFalse(Plugin::needsReloadAfterInstall());
        $this->assertTrue(Plugin::uninstall());
        $this->assertTrue(Plugin::isInstalled());
        $this->assertTrue(Plugin::install());
        $this->assertTrue(Plugin::isInstalled());
        $this->assertNull(Plugin::getTranslationFile('en'));

        if (!$isInstalled) {
            Plugin::uninstall();
        }
    }
}
