<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveChangesTracking\Tests\Worker;

use SaveChangesTracking\Api\Manager as ApiManager;
use SaveChangesTracking\Worker\Manager;

/***
 * Class ManagerTest
 * @package SaveChangesTracking\Tests\Worker
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Manager
     */
    private $testObject = null;

    public function setUp()
    {
        $apiManager = new ApiManager();
        $this->testObject = new Manager($apiManager);
    }

    public function testChangesTracking()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertInstanceOf('SaveChangesTracking\Worker\ChangesTracking', $this->testObject->changesTracking());
    }
}
