<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveEvent;

use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Class CopyDefaultDescription
 *
 * @package SaveEvent
 */
class CopyDefaultDescription
{

    /**
     * handle
     *
     * @param ArtikelFamilie|ProduktGruppe $object
     *
     * @return ArtikelFamilie|ProduktGruppe
     */
    public function handle($object)
    {

        if ($object instanceof ProduktGruppe) {
            $this->copyTextProductGroup($object);
        }

        if ($object instanceof ArtikelFamilie) {
            $this->copyTextArticleFamily($object);
        }

        return $object;
    }

    /**
     * copyTextArticleFamily
     *
     * @param ArtikelFamilie $object
     */
    public function copyTextArticleFamily($object)
    {

        $object->setDisplayLangtextDefaultBigtree($object->getArtikelFamilieLangtextBigtree('de'));
        $object->setDisplayLangtextDefaultStylefile($object->getArtikelFamilieLangtextStylefile('de'));
    }

    /**
     * copyTextProductGroup
     *
     * @param ProduktGruppe $object
     */
    public function copyTextProductGroup($object)
    {

        $object->setDisplayLangtextDefaultBigtree($object->getProduktGruppeLangtextBigtree('de'));
        $object->setDisplayLangtextDefaultStylefile($object->getProduktGruppeLangtextStylefile('de'));
    }
}
