<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\SaveEvent;

use SaveEvent\Plugin;
use Pimcore\Model\Object\ArtikelFamilie;

/**
 * Class PluginTest
 *
 * @package Tests\SaveEvent
 */
class PluginTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Plugin
     */
    private $object;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->object = new Plugin();
    }

    public function testInstall()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertTrue(Plugin::install());
    }

    public function testUninstall()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertTrue(Plugin::uninstall());
    }

    public function testIsInstalled()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $this->assertTrue(Plugin::isInstalled());
    }

    public function testHandleObjectPreSaveEvent()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $event = new \Zend_EventManager_Event();

        $articleFamily = new ArtikelFamilie();
        $articleFamily->setArtikelFamilieLangtextBigtree('dummy text', 'de');
        $event->setTarget($articleFamily);

        $this->object->handleObjectPreSaveEvent($event);

        $this->assertEquals('dummy text', $event->getTarget()->getDisplayLangtextDefaultBigtree());
    }
}
