<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\SaveEventBundle\EventListener;

use Pimcore\Model\Element\ElementInterface;
use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Class CopyDefaultDescription
 *
 * @package Publikat\Pimcore\SaveEventBundle\EventListener
 */
class CopyDefaultDescription
{
    /**
     * handle
     *
     * @param ElementInterface $object
     *
     * @return ElementInterface
     */
    public function handle($object)
    {

        if ($object instanceof ProduktGruppe) {
            $this->copyTextProductGroup($object);
        }

        if ($object instanceof ArtikelFamilie) {
            $this->copyTextArticleFamily($object);
        }

        return $object;
    }

    /**
     * copyTextArticleFamily
     *
     * @param ArtikelFamilie $object
     */
    public function copyTextArticleFamily($object)
    {
        // Langtexte
        $object->setDisplayLangtextDefaultBigtree($object->getArtikelFamilieLangtextBigtree('de'));
        $object->setDisplayLangtextDefaultStylefile($object->getArtikelFamilieLangtextStylefile('de'));
        // Zusammengefasste Textfelder
        $localizedFields = $object->getLocalizedfields()->getInternalData()['de'];
        $combined = '';
        foreach ($localizedFields as $key => $value) {
            // STYLEFILE-5458 : Ignore arrays like on bullet points (blocks)
            if (!is_array($value) && !is_null($value) && trim($value) != '' && !strstr($key, 'Langtext')) {
                $combined .= '<b>'.substr($key, strlen('datenblatt')) . '</b>: ' . $value . '</br>';
            }
        }
        $object->setDisplayTextfelderDefault($combined);
    }

    /**
     * copyTextProductGroup
     *
     * @param ProduktGruppe $object
     */
    public function copyTextProductGroup($object)
    {
        $object->setDisplayLangtextDefaultBigtree($object->getProduktGruppeLangtextBigtree('de'));
        $object->setDisplayLangtextDefaultStylefile($object->getProduktGruppeLangtextStylefile('de'));
    }
}
