<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\SaveEvent;

use SaveEvent\CopyDefaultDescription;
use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Class CopyDefaultDescriptionTest
 *
 * @package Tests\SaveEvent
 */
class CopyDefaultDescriptionTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var CopyDefaultDescription
     */
    private $object;

    public function setUp()
    {

        $this->object = new CopyDefaultDescription();
    }

    public function testHandleArticleFamilyBigtree()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $articleFamily = new ArtikelFamilie();
        $articleFamily->setArtikelFamilieLangtextBigtree('dummy text familie bigtree', 'de');

        $articleFamily = $this->object->handle($articleFamily);

        $this->assertEquals('dummy text familie bigtree', $articleFamily->getDisplayLangtextDefaultBigtree());
    }

    public function testHandleArticleFamilyStylefile()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $articleFamily = new ArtikelFamilie();
        $articleFamily->setArtikelFamilieLangtextStylefile('dummy text familie stylefile', 'de');
        $articleFamily->setDatenblattMethode('Test');
        $articleFamily->setDatenblattExtras('Test2');

        $articleFamily = $this->object->handle($articleFamily);

        $this->assertEquals('dummy text familie stylefile', $articleFamily->getDisplayLangtextDefaultStylefile());
        $this->assertEquals('Methode: Test\r\nExtras: Test2\r\n', $articleFamily->getDisplayTextfelderDefault());
    }

    public function testHandleProductGroupBigtree()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $articleFamily = new ProduktGruppe();
        $articleFamily->setProduktGruppeLangtextBigtree('dummy text gruppe bigtree', 'de');

        $articleFamily = $this->object->handle($articleFamily);

        $this->assertEquals('dummy text gruppe bigtree', $articleFamily->getDisplayLangtextDefaultBigtree());
    }

    public function testHandleProductGroupStylefile()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $articleFamily = new ProduktGruppe();
        $articleFamily->setProduktGruppeLangtextStylefile('dummy text gruppe stylefile', 'de');

        $articleFamily = $this->object->handle($articleFamily);

        $this->assertEquals('dummy text gruppe stylefile', $articleFamily->getDisplayLangtextDefaultStylefile());
    }
}
