<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\SaveEvent;

use SaveEvent\PrioDescription;
use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Class PrioDescriptionTest
 *
 * @package Tests\SaveEvent
 */
class PrioDescriptionTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var PrioDescription
     */
    private $object;

    public function setUp()
    {
        $this->object = new PrioDescription();
    }

    public function testSetPrioProductGroup()
    {
        $this->markTestSkipped('TODO: fix for Pimcore 5 migration');
        $articleFamily = new ArtikelFamilie();
        $articleFamily->setDisplayPrioLangtextStylefile(0);
        $articleFamily->setDisplayPrioLangtextBigtree(1);

        $produktGruppe = New ProduktGruppe();
        $produktGruppe->setDisplayPrioLangtextStylefile(1);
        $produktGruppe->setDisplayPrioLangtextBigtree(0);

        $object = $this->object->setPrioProductGroup($articleFamily, $produktGruppe);

        $this->assertEquals($articleFamily->getDisplayPrioLangtextStylefile(), $object->getDisplayPrioLangtextStylefile());
        $this->assertEquals($articleFamily->getDisplayPrioLangtextBigtree(), $object->getDisplayPrioLangtextBigtree());
        $this->assertEquals(0, $object->getDisplayPrioLangtextStylefile());
        $this->assertEquals(1, $object->getDisplayPrioLangtextBigtree());
    }

}