<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\SaveEventBundle\EventListener;

use Pimcore\Event\Model\ElementEventInterface;

/**
 * Class DataObjectListener
 *
 * @package Publikat\Pimcore\SaveEventBundle\EventListener
 */
class DataObjectListener
{
    /**
     * @var CopyDefaultDescription
     */
    private $copyDefaultDescription;

    /**
     * DataObjectListener constructor.
     *
     * @param CopyDefaultDescription $copyDefaultDescription
     */
    public function __construct(CopyDefaultDescription $copyDefaultDescription)
    {
        $this->copyDefaultDescription = $copyDefaultDescription;
    }

    /**
     * @param ElementEventInterface $event
     */
    public function onPreUpdate(ElementEventInterface $event)
    {
        $object = $event->getElement();
        $this->copyDefaultDescription->handle($object);
    }
}