<?php

namespace SaveEvent;

use Pimcore\API\Plugin as PluginLib;

/**
 * Class Plugin
 *
 * @package SaveEvent
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{

    /**
     * init
     *
     * @throws \Zend_EventManager_Exception_InvalidArgumentException
     */
    public function init()
    {
        parent::init();

        \Pimcore::getEventManager()->attach("object.preUpdate", [$this, "handleObjectPreSaveEvent"]);
    }

    /**
     * handleObjectPreSaveEvent
     *
     * @param \Zend_EventManager_Event $event
     */
    public function handleObjectPreSaveEvent(\Zend_EventManager_Event $event)
    {

        $object = $event->getTarget();

        $handleObject = new CopyDefaultDescription();
        $handleObject->handle($object);

        // Deaktiviert STYLEFILE-3393... kann beim nächsten mal raus!
        //$handleObjectPrio = new PrioDescription();
        //$handleObjectPrio->handle($object);
    }

    /**
     * install
     *
     * @return bool
     */
    public static function install()
    {
        // implement your own logic here
        return true;
    }

    /**
     * uninstall
     *
     * @return bool
     */
    public static function uninstall()
    {
        // implement your own logic here
        return true;
    }

    /**
     * isInstalled
     *
     * @return bool
     */
    public static function isInstalled()
    {
        // implement your own logic here
        return true;
    }
}
